<?php

new class {

    protected $dir;
    protected $user;

    public function __construct() {
        
        $this->user = Uss::$global['user'];

        if( $_SERVER['REQUEST_METHOD'] !== 'POST' || empty($this->user) ) return;

        $this->buildCheque( $_FILES['cheque'] );

    }

    protected function buildCheque( $file ) {  

        if( !empty($file['error']) ) {

            return Bank::log('error', "Sorry! There was an error in the process");

        }

        # Upload The file

        try {

            $mime = "image/jpg|png|jpeg|webp";
            
            $dir = Transfer::IMG_DIR . "/cheques";

            $link = Udash::uploadFile( $mime, $file, $dir, $this->user['id'] . uniqid() );

            $this->saveCheque( $link );

        } catch(Exception $e) {

            Bank::log( 'error', $e->getMessage() );

        }

    }

    protected function saveCheque( ?string $link ) {

        $data = array(
            "userid" => $this->user['id'],
            "image" => $link
        );

        $SQL = SQuery::insert( DB_TABLE_PREFIX . "_cheques", $data );

        $insert = Uss::$global['mysqli']->query( $SQL );

        if( !$insert ) {
            
            Bank::log( 'error', 'Your cheque was not uploaded. <br/> If the problem persist, contact the support team.' );

        } else {

            Bank::log( 'success', 'Thank you! <br/> Your cheque has been uploaded successfully.' );

        };

    }

};

