<?php

$depositRoute = $moniRoute . "/deposit";

$depositMenu = $moniMenu->add("deposit", [
    "label" => "digital deposit",
    "href" => Core::url( ROOT_DIR . "/{$depositRoute}" )
]);

# Done!

Uss::route( $depositRoute, function() use($depositMenu) {

    $depositMenu->setAttr('active', true);
    $depositMenu->parentMenu->setAttr('active', true);

    $methods = SQuery::select( DB_TABLE_PREFIX . "_payment_methods", "status = 1" );
    $methods = Uss::$global['mysqli']->query( $methods );

    Monetary::handleDepositRequest();
    
    $methods = Udash::mysqli_to_array($methods);

    if( !empty($methods) ) {
        $method = Monetary::getMethod( $_GET['method'] ?? 0 ); 
        Monetary::getQRCode( $method );
    } else $method = null;

    Udash::view(function() use($methods, $method) {
        
        if( !empty($methods) ) {

            require_once Monetary::TEMP_DIR . "/methods.php";

        } else {

            echo "
                <div class='container-fluid'>
                    <div class='row'>
                        <div class='col-md-7 mx-auto'>

                            <div class='card'>
                                <div class='card-body'>
                                    <div class='text-center py-4'>

                                        <h2 class='fw-light'>
                                            No Payment Method Available
                                        </h2>

                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>  
                </div>
            ";

        };

    });

}, null);
