<?php

# d-* = display
# m-* = margin
# p-* = padding etc.

// sizes: sm, md, lg, xl, xxl

# "d-none" is a bootstrap class for "display: none";

Uss::tag('col.left', "d-none");


# Move Right column to center

/**
 * d-* in bootstrap is "display";
 * 
 * # Example:
 * 
 * d-lg-8 means display large 8
 * d-md-4 means display middle 4
 * 
 * Which means that when the screen is large, it will display 80% of the container size
 * When the screen is at medium size, it will display 40% of the container size
 * 
 * m-* in bootstrap means "margin";
 * 
 * # Example
 * 
 * m-auto means margin auto
 * m-lg-5 means margin will be 5rem when the screen is large
 * m-sm-3 means margin will be 3rem when the screen is small
 * 
 * Thus, we're going to resize the block and apply m-auto so the block can move to the center of the page
 * 
 * We've applied d-lg-6 but the size is too big, so we have to reduce the number
 * Let's try d-lg-4
 * 
 * Okay, the error we've been making is that we're using d-* directive which means display
 * Display will make the content visible or invisble in the page
 * 
 * What we actually needed was the col-* directive
 * Which means column
 * 
 * Therefore, we'll replace d-lg-4 with col-lg-4
 * 
 * Resolved, but too small. 
 * 
 * Let that be all for now.
 * We'll proceed later
 */
Uss::tag('col.right', "col-md-10 col-lg-8 col-xl-7 m-auto py-5");

# Add border and shadow

Uss::tag('auth.container', 'border py-3 px-4 rounded-2 shadow m-1 mx-2 mx-sm-4');

# Add icon

Events::addListener('udash:auth.right', function() {
    echo "<div class='text-center'>
        <span class='fs-42px text-danger animate__animated animate__pulse d-inline-block'>
            <i class='bi bi-shield-lock'></i>
        </span>
    </div>";
}, "Bank-icon");

