<?php

Events::addListener('uadmin:pages/users@options.dropdown', function($data) use($userRoute) { ?>
 <li>
	<a class='dropdown-item' href='<?php echo Core::url( ROOT_DIR . "/{$userRoute}/@credential/{$data['usercode']}" ); ?>'>
		<i class='bi bi-info-circle me-1'></i> Credential
	</a>
</li>
<?php }, EVENT_ID . "credential");

# Focus

Uss::route( $userRoute . "/@credential/(\w+)", function($match) {
	
	//Uss::$global['menu']->get('_users')->get('list')->setAttr('active', true);

	$user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $match[1], "usercode" );

	Bank::setUserMeta( $user['id'] );
	
	require_once __DIR__ . "/request/edit-credentials-post.php";
	
	Udash::view(function() use($user) {

		$bankinfo = Uss::$global['usermeta']->get('bank:info', $user['id']);

		if( !$bankinfo ) return Udash::empty_state('No Credential Found For this user');

		elseif( empty($bankinfo['bio']['firstname']) ) {
			return Udash::empty_state('Please update the user account <br/> Some information are required to display credentials', "account not updated");
		};

		foreach( $bankinfo as $key => $value ) {
			$$key = $value;
		};

		$bankNumber = Uss::$global['usermeta']->get('bank:number', $user['id']);
		$userBalance = Uss::$global['usermeta']->get('bank:balance', $user['id']) ?: 0;
		$currency = Bank::getCurrencies( $bankinfo['system']['currency'] );
		$bankOTP = Uss::$global['usermeta']->get('bank:otp', $user['id']);

		$currencies = Uss::$global['options']->get('bank:currencies');
		
		require __DIR__ . "/templates/user-credential.php";

	});	

}, null);