<div class='container-fluid'>

    <h3 class=''>Deposits</h3><hr/>

    <?php

        $SQL = SQuery::select( DB_TABLE_PREFIX . "_deposits", "1 ORDER BY id DESC" );

        $result = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet( 'deposits' );

        $tablet->data( $result );

        $tablet->columns([
            'user',
            "usd_amount" => 'amount',
            "tx_ref" => "TNX",
            "network",
            "rate",
            "date",
            "status",
            "action" => ''
        ]);

        $tablet->wrap();

        $tablet->prepare(function($data) {

            $data['detail'] = json_decode($data['detail']);

            $user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data['userid'] );

            $encode = base64_encode(json_encode($data));
            
            if( !$user ) $data['user'] = "<i class='bi bi-person-slash'></i>";
            else {
                $userlink = Core::url( ROOT_DIR . "/" . UADMIN_ROUTE . "/users/{$user['usercode']}" );
                $data['user'] = "
                    <a href='{$userlink}'>
                        {$user['email']}
                    </a>
                ";
            };

            $data['usd_amount'] = '$' . number_format($data['usd_amount'], 2);

            $color = Udash::get_color( $data['status'] );
            $data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";

            $data['action'] = "
                <a href='?remove={$data['id']}' data-uss-confirm='Sure you want to delete the deposit?' class='btn btn-danger mb-1'>
                    <i class='bi bi-trash'></i>
                </a>
                <button class='btn btn-outline-info mb-1' data-decoder='{$encode}'>
                    <i class='bi bi-pen'></i>
                </button>
            ";

            return $data;

        }, true);

    ?>

</div>

<template data-template='editor'>
    <div class='p-3'>
        <form method='POST'>
            <fieldset>
                
                <h5>{{tx_ref}}</h5> <hr>

                <div class='mb-2'>
                    <label class='form-label'>Amount</label>
                    <div class='input-group'>
                        <span class='input-group-text'>$</span>
                        <input type='number' step='0.01' name='usd_amount' class='form-control' value='{{usd_amount}}'>
                    </div>
                </div>

                <div class='mb-2'>
                    <label class='form-label'>TXID</label>
                    <input type='text' disabled class='form-control' value='{{txid}}'>
                </div>

                <div class='mb-2'>
                    <label class='form-label'>Status</label>
                    <select class='form-select' name='status' value='{{status}}' data-status>
                        <option value='approved'>Approved</option>
                        <option value='pending'>Pending</option>
                        <option value='declined'>Declined</option>
                    </select>
                </div>

                <input type='hidden' name='id' value='{{id}}'>

                <button class='btn btn-success w-100'>
                    Update
                </button>

                <hr>

                <div class=''>
                    Paid: {{paid}}
                </div>

                <hr/>

                <div data-detail class='table-responsive'>
                    <table class='table table-bordered'>
                        <tbody></tbody>
                    </table>
                </div>

            </fieldset>
        </form>
    </div>
</template>

<template data-template='tr'>
    <tr>
        <td data-key></td>
        <td data-value></td>
    </tr>
</template>